package ru.yandex.partner.core.entity.block.type.rtb

import NPartner.Page.TPartnerPage
import org.springframework.stereotype.Component
import ru.yandex.partner.core.CoreConstants
import ru.yandex.partner.core.entity.block.container.BlockBkDictContainer
import ru.yandex.partner.core.entity.block.model.BlockWithRtbFieldsStrategyAndShowVideo
import ru.yandex.partner.core.entity.block.repository.BlockBkFiller
import ru.yandex.partner.libs.bs.ext.adTypeSet
import java.math.BigDecimal

@Component
class BlockWithRtbFieldsAndShowVideoBkFiller : BlockBkFiller<BlockWithRtbFieldsStrategyAndShowVideo> {
    override fun fillBkData(
        block: BlockWithRtbFieldsStrategyAndShowVideo,
        bkData: TPartnerPage.TBlock.Builder,
        container: BlockBkDictContainer
    ) {

        val textNotBlocked = (block.textBlocked == true).not()
        val mediaNotBlocked = (block.mediaBlocked == true).not()
        val videoNotBlocked = block.showVideo && (block.videoBlocked == true).not()
        bkData.adTypeSet(TPartnerPage.TBlock.EAdType.TEXT)
            .setValue(textNotBlocked)

        bkData.adTypeSet(TPartnerPage.TBlock.EAdType.MEDIA)
            .setValue(mediaNotBlocked)
        bkData.adTypeSet(TPartnerPage.TBlock.EAdType.MEDIA_PERFORMANCE)
            .setValue(mediaNotBlocked)

        bkData.adTypeSet(TPartnerPage.TBlock.EAdType.VIDEO)
            .setValue(videoNotBlocked)
        bkData.adTypeSet(TPartnerPage.TBlock.EAdType.VIDEO_PERFORMANCE)
            .setValue(videoNotBlocked)
        // floorad always false
        bkData.adTypeSet(TPartnerPage.TBlock.EAdType.VIDEO_MOTION)
            .setValue(videoNotBlocked)


        if (block.textActive == true && textNotBlocked) {
            bkData.addAdTypeBuilder()
                .setAdType(TPartnerPage.TBlock.EAdType.TEXT)
                .setCurrency(CoreConstants.Currency.DEFAULT)
                .setValue(block.textCpm.multiply(BigDecimal(1000)).longValueExact())
        }

        if (block.mediaActive == true && mediaNotBlocked) {
            val mediaCpm = block.mediaCpm.multiply(BigDecimal(1000)).longValueExact()
            bkData.addAdTypeBuilder()
                .setAdType(TPartnerPage.TBlock.EAdType.MEDIA)
                .setCurrency(CoreConstants.Currency.DEFAULT)
                .setValue(mediaCpm)
            bkData.addAdTypeBuilder()
                .setAdType(TPartnerPage.TBlock.EAdType.MEDIA_PERFORMANCE)
                .setCurrency(CoreConstants.Currency.DEFAULT)
                .setValue(mediaCpm)
        }

        if (block.videoActive == true && videoNotBlocked) {
            val videoCpm = block.videoCpm.multiply(BigDecimal(1000)).longValueExact()
            bkData.addAdTypeBuilder()
                .setAdType(TPartnerPage.TBlock.EAdType.VIDEO)
                .setCurrency(CoreConstants.Currency.DEFAULT)
                .setValue(videoCpm)
            bkData.addAdTypeBuilder()
                .setAdType(TPartnerPage.TBlock.EAdType.VIDEO_PERFORMANCE)
                .setCurrency(CoreConstants.Currency.DEFAULT)
                .setValue(videoCpm)

            bkData.addAdTypeBuilder()
                .setAdType(TPartnerPage.TBlock.EAdType.VIDEO_MOTION)
                .setCurrency(CoreConstants.Currency.DEFAULT)
                .setValue(videoCpm)
        }

        if (block.blockId == CoreConstants.TECHNICAL_RTB_BLOCK_ID) {
            bkData.adTypeSet(TPartnerPage.TBlock.EAdType.MEDIA)
                .setValue(true)
            bkData.adTypeSet(TPartnerPage.TBlock.EAdType.MEDIA_PERFORMANCE)
                .setValue(true)
        }
    }

    override fun getTypeClass(): Class<BlockWithRtbFieldsStrategyAndShowVideo> {
        return BlockWithRtbFieldsStrategyAndShowVideo::class.java
    }

    override fun order(): Int {
        return BlockBkFiller.Order.RTB_FIELDS_AND_SHOW_VIDEO.ordinal
    }
}
