package ru.yandex.partner.core.entity.block.type.rtb;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.partner.core.entity.block.model.BlockWithRtbFields;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.operation.CoreModelProvider;
import ru.yandex.partner.core.props.CoreModel;
import ru.yandex.partner.core.props.ModelPropertyDefault;
import ru.yandex.partner.core.utils.CommonConverters;

import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_RTB;

@Component
@ParametersAreNonnullByDefault
public class BlockWithRtbFieldsRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupportWithMapper<BlockWithRtbFields>
        implements CoreModelProvider<BlockWithRtbFields> {
    private static final CoreModel<BlockWithRtbFields> DEFAULT_VALUES =
            CoreModel.forClass(BlockWithRtbFields.class)
                    .property(
                            ModelPropertyDefault.<BlockWithRtbFields, Boolean>forProperty(
                                            BlockWithRtbFields.HORIZONTAL_ALIGN
                                    )
                                    .mandatoryOnAdd(() -> Boolean.TRUE)
                    )
                    .property(ModelPropertyDefault.<BlockWithRtbFields, Long>forProperty(
                            BlockWithRtbFields.BLIND
                    ).withDefaultValueOnAdd(0L))
                    .build();
    private final JooqMapper<BlockWithRtbFields> mapper;

    @Autowired
    protected BlockWithRtbFieldsRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext);
        this.mapper = createCommonBlockMapper();
    }

    private static JooqMapper<BlockWithRtbFields> createCommonBlockMapper() {
        return JooqMapperBuilder.<BlockWithRtbFields>builder()
                .map(property(BlockWithRtbFields.BLIND, CONTEXT_ON_SITE_RTB.BLIND))
                .map(convertibleProperty(BlockWithRtbFields.HORIZONTAL_ALIGN, CONTEXT_ON_SITE_RTB.HORIZONTAL_ALIGN,
                        CommonConverters::booleanFromLong, CommonConverters::booleanToLong))
                .build();
    }

    @Override
    public JooqMapper<BlockWithRtbFields> getJooqMapper() {
        return mapper;
    }

    @Override
    public Class<BlockWithRtbFields> getTypeClass() {
        return BlockWithRtbFields.class;
    }

    @Override
    public CoreModel<BlockWithRtbFields> getCoreModel() {
        return DEFAULT_VALUES;
    }

}
