package ru.yandex.partner.core.entity.block.type.rtb;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithRtbFields;
import ru.yandex.partner.core.entity.block.service.validation.type.AbstractBlockValidationTypeSupport;

@Component
public class BlockWithRtbFieldsValidationTypeSupport extends AbstractBlockValidationTypeSupport<BlockWithRtbFields> {
    private final Validator<BlockWithRtbFields, Defect> validator;

    @Autowired
    public BlockWithRtbFieldsValidationTypeSupport(BlockWithRtbFieldsValidatorProvider validatorProvider) {
        this.validator = validatorProvider.validator();
    }

    @Override
    public Class<BlockWithRtbFields> getTypeClass() {
        return BlockWithRtbFields.class;
    }

    @Override
    public ValidationResult<List<BlockWithRtbFields>, Defect> validate(
            BlockContainer container,
            ValidationResult<List<BlockWithRtbFields>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validator)
                .getResult();
    }
}
