package ru.yandex.partner.core.entity.block.type.rtb;

import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;
import ru.yandex.partner.core.entity.block.model.BlockWithRtbFields;
import ru.yandex.partner.core.validation.defects.PartnerCollectionDefects;

import static ru.yandex.direct.validation.constraint.CommonConstraints.inSet;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.partner.core.CoreConstants.BLIND_VALUES;
import static ru.yandex.partner.core.validation.defects.TypeDefects.invalidTypeMustBeDefined;

@Component
public class BlockWithRtbFieldsValidatorProvider {

    public <M extends BlockWithRtbFields> Validator<M, Defect> validator() {
        return block -> {
            var vb = ModelItemValidationBuilder.of(block);
            vb.item(BlockWithRtbFields.BLIND)
                    .check(notNull(), invalidTypeMustBeDefined())
                    .check(inSet(BLIND_VALUES), PartnerCollectionDefects.inSet(BLIND_VALUES), When.isValid());
            return vb.getResult();
        };
    }
}
