package ru.yandex.partner.core.entity.block.type.rtb

import NPartner.Page.TPartnerPage
import org.springframework.stereotype.Component
import ru.yandex.partner.core.CoreConstants
import ru.yandex.partner.core.entity.block.container.BlockBkDictContainer
import ru.yandex.partner.core.entity.block.formats.MediaFormat.Companion.buildMediaFormat
import ru.yandex.partner.core.entity.block.model.CommonContextRtbBlock
import ru.yandex.partner.core.entity.block.repository.BlockBkFiller

@Component
class CommonContextRtbBlockBkFiller : BlockBkFiller<CommonContextRtbBlock> {
    override fun fillBkData(
        block: CommonContextRtbBlock,
        bkData: TPartnerPage.TBlock.Builder,
        container: BlockBkDictContainer
    ) {
        val mediaBlock = block.dspBlocks.mapNotNull { dspBlock ->
            buildMediaFormat(dspBlock)?.also {
                val sizeBuilder = TPartnerPage.TBlock.TSize.newBuilder()
                sizeBuilder.height = it.height
                sizeBuilder.width = it.width
                if (it.percent.isNotBlank()) {
                    sizeBuilder.width = 0
                }
                bkData.addSizes(sizeBuilder)
            }
        }.maxByOrNull {
            it.square
        }

        mediaBlock?.let {
            bkData.height = it.height
            bkData.width = it.width
            if (it.percent.isNotBlank()) {
                bkData.width = 0
            }
        }

        val alreadyHas0x0 = mediaBlock?.width == 0 && mediaBlock.height == 0
        if (!alreadyHas0x0) {
            val builder0x0 = TPartnerPage.TBlock.TSize.newBuilder()
            builder0x0.width = 0
            builder0x0.height = 0
            bkData.addSizes(builder0x0)
        }

        bkData.dspType = bkData.dspType or CoreConstants.DspTypes.DSP_MEDIA.bkId() // 2^0 media

        bkData.blindLevel = block.blind.toInt()
    }

    override fun getTypeClass(): Class<CommonContextRtbBlock> {
        return CommonContextRtbBlock::class.java
    }
}
