package ru.yandex.partner.core.entity.block.type.rtb;

import java.util.Set;

import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.block.BlockType;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.CommonRtbBlock;
import ru.yandex.partner.core.entity.block.service.type.update.AbstractBlockUpdateOperationTypeSupport;
import ru.yandex.partner.core.multitype.repository.PartnerRepositoryTypeSupportFacade;

@Component
public class CommonRtbBlockUpdateOperationTypeSupport
        extends AbstractBlockUpdateOperationTypeSupport<CommonRtbBlock> {
    private static final Set<ModelProperty<? super CommonRtbBlock, ?>> NEED_UPDATE_IN_BK_FIELDS = Set.of(
            CommonRtbBlock.BLIND,
            CommonRtbBlock.HORIZONTAL_ALIGN,
            CommonRtbBlock.DSP_BLOCKS
    );

    public CommonRtbBlockUpdateOperationTypeSupport(PartnerRepositoryTypeSupportFacade<BaseBlock, BlockType,
            BlockContainer, BlockContainer> repositoryFacade) {
        super(repositoryFacade);
    }

    @Override
    public Class<CommonRtbBlock> getTypeClass() {
        return CommonRtbBlock.class;
    }

    @Override
    public Set<ModelProperty<? super CommonRtbBlock, ?>> needBsResyncProps() {
        return NEED_UPDATE_IN_BK_FIELDS;
    }
}
