package ru.yandex.partner.core.entity.block.type.rtbblock.external;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;

import NPartner.Page.TPartnerPage;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.CoreConstants;
import ru.yandex.partner.core.entity.block.container.BlockBkDictContainer;
import ru.yandex.partner.core.entity.block.model.RtbBlock;
import ru.yandex.partner.core.entity.block.repository.BlockBkFiller;
import ru.yandex.partner.core.entity.designtemplates.model.DesignTemplates;

@Component
public class RtbBlockBkFiller implements BlockBkFiller<RtbBlock> {

    @Override
    public void fillBkData(@NotNull RtbBlock model,
                           @NotNull TPartnerPage.TBlock.Builder bkData,
                           BlockBkDictContainer container) {
        List<DesignTemplates> designTemplates = Objects.requireNonNullElseGet(model.getDesignTemplates(), List::of);
        var directFormat = designTemplates.stream()
                .filter(design -> design.getType() == CoreConstants.DEFAULT_DESIGN_TEMPLATES_TYPE)
                .min(Comparator.comparing(DesignTemplates::getId))
                .map(DesignTemplates::getDesignSettings)
                .map(settings -> (String) settings.get("name"))
                .orElse("");

        if ("modernAdaptive".equals(directFormat)) {
            bkData.getPageImpOptionsBuilder().addEnable("filter-sizes");
        } else {
            bkData.getPageImpOptionsBuilder().addDisable("filter-sizes");
        }

        if ("adaptive".equals(directFormat) || "modernAdaptive".equals(directFormat)) {
            bkData.getPageImpOptionsBuilder().addEnable("ignore-0x0-adaptive-sizes");
        } else {
            bkData.getPageImpOptionsBuilder().addDisable("ignore-0x0-adaptive-sizes");
        }
    }

    @Override
    public Class<RtbBlock> getTypeClass() {
        return RtbBlock.class;
    }
}
