package ru.yandex.partner.core.entity.block.type.rtbblock.external;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.CoreConstants;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.RtbBlock;
import ru.yandex.partner.core.entity.block.type.common.BlockWithCommonFieldsDspRules;
import ru.yandex.partner.core.entity.block.type.common.ExternalBlockWithCommonFieldsDspRules;
import ru.yandex.partner.core.entity.block.type.dspsshowvideandsiteversion.BlockWithDspsShowVideoAndSiteVersionDspRules;
import ru.yandex.partner.core.entity.block.type.dspsshowvideandsiteversion.ExternalBlockWithDspsShowVideoAndSiteVersionDspRules;
import ru.yandex.partner.core.entity.block.type.page.BlockWithContextPageDspRules;
import ru.yandex.partner.core.entity.block.type.page.BlockWithPageDspRules;
import ru.yandex.partner.core.entity.dsp.rules.DspRuleComponent;
import ru.yandex.partner.core.entity.dsp.rules.DspRuleContainer;
import ru.yandex.partner.core.entity.dsp.rules.DspRuleSet;

@Component
public class RtbBlockDspRules extends DspRuleComponent<RtbBlock> {
    private final BlockWithCommonFieldsDspRules blockWithCommonFieldsDspRules;
    private final BlockWithDspsShowVideoAndSiteVersionDspRules
            blockWithShowVideoAndSiteVersionDspRules;
    private final BlockWithContextPageDspRules blockWithContextPageDspRules;
    private final BlockWithPageDspRules blockWithPageDspRules;

    @Autowired
    public RtbBlockDspRules(
            ExternalBlockWithCommonFieldsDspRules blockWithCommonFieldsDspRules,
            ExternalBlockWithDspsShowVideoAndSiteVersionDspRules blockWithShowVideoAndSiteVersionDspRules,
            BlockWithContextPageDspRules blockWithContextPageDspRules,
            BlockWithPageDspRules blockWithPageDspRules) {
        this.blockWithCommonFieldsDspRules = blockWithCommonFieldsDspRules;
        this.blockWithShowVideoAndSiteVersionDspRules = blockWithShowVideoAndSiteVersionDspRules;
        this.blockWithContextPageDspRules = blockWithContextPageDspRules;
        this.blockWithPageDspRules = blockWithPageDspRules;
    }

    @Override
    public Class<RtbBlock> getEntireTypeClass() {
        return RtbBlock.class;
    }

    @Override
    public DspRuleSet getDspRuleSet(DspRuleContainer container) {
        return new DspRuleSet()
                .withRuleSet(blockWithCommonFieldsDspRules.getDspRuleSet(container))
                .withRuleSet(blockWithShowVideoAndSiteVersionDspRules.getDspRuleSet(container))
                .withRuleSet(blockWithContextPageDspRules.getDspRuleSet(container))
                .withRuleSet(blockWithPageDspRules.getDspRuleSet(container));
    }

    @Override
    public void fillDspRuleContainer(DspRuleContainer container, BaseBlock entity) {
        blockWithCommonFieldsDspRules.fillDspRuleContainer(container, entity);
        blockWithShowVideoAndSiteVersionDspRules.fillDspRuleContainer(container, entity);
        blockWithContextPageDspRules.fillDspRuleContainer(container, entity);
        blockWithPageDspRules.fillDspRuleContainer(container, entity);

        container.addDspType(CoreConstants.DspTypes.DSP_MEDIA);
    }
}
