package ru.yandex.partner.core.entity.block.type.rtbblock.internal;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.CoreConstants;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.InternalRtbBlock;
import ru.yandex.partner.core.entity.block.type.common.BlockWithCommonFieldsDspRules;
import ru.yandex.partner.core.entity.block.type.common.InternalBlockWithCommonFieldsDspRules;
import ru.yandex.partner.core.entity.block.type.dspsshowvideandsiteversion.BlockWithDspsShowVideoAndSiteVersionDspRules;
import ru.yandex.partner.core.entity.block.type.dspsshowvideandsiteversion.InternalBlockWithDspsShowVideoAndSiteVersionDspRules;
import ru.yandex.partner.core.entity.block.type.page.BlockWithPageDspRules;
import ru.yandex.partner.core.entity.dsp.rules.DspRuleComponent;
import ru.yandex.partner.core.entity.dsp.rules.DspRuleContainer;
import ru.yandex.partner.core.entity.dsp.rules.DspRuleSet;

@Component
public class InternalRtbBlockDspRules extends DspRuleComponent<InternalRtbBlock> {
    private final BlockWithCommonFieldsDspRules blockWithCommonFieldsDspRules;
    private final BlockWithDspsShowVideoAndSiteVersionDspRules
            blockWithShowVideoAndSiteVersionDspRules;
    private final BlockWithPageDspRules blockWithPageDspRules;

    @Autowired
    public InternalRtbBlockDspRules(
            InternalBlockWithCommonFieldsDspRules blockWithCommonFieldsDspRules,
            InternalBlockWithDspsShowVideoAndSiteVersionDspRules blockWithShowVideoAndSiteVersionDspRules,
            BlockWithPageDspRules blockWithPageDspRules) {
        this.blockWithCommonFieldsDspRules = blockWithCommonFieldsDspRules;
        this.blockWithShowVideoAndSiteVersionDspRules = blockWithShowVideoAndSiteVersionDspRules;
        this.blockWithPageDspRules = blockWithPageDspRules;
    }

    @Override
    public Class<InternalRtbBlock> getEntireTypeClass() {
        return InternalRtbBlock.class;
    }

    @Override
    public DspRuleSet getDspRuleSet(DspRuleContainer container) {
        return new DspRuleSet()
                .withRuleSet(blockWithCommonFieldsDspRules.getDspRuleSet(container))
                .withRuleSet(blockWithShowVideoAndSiteVersionDspRules.getDspRuleSet(container))
                .withRuleSet(blockWithPageDspRules.getDspRuleSet(container));
    }

    @Override
    public void fillDspRuleContainer(DspRuleContainer container, BaseBlock entity) {
        blockWithCommonFieldsDspRules.fillDspRuleContainer(container, entity);
        blockWithShowVideoAndSiteVersionDspRules.fillDspRuleContainer(container, entity);
        blockWithPageDspRules.fillDspRuleContainer(container, entity);
        container.addDspType(CoreConstants.DspTypes.DSP_MEDIA);
    }
}
