package ru.yandex.partner.core.entity.block.type.rtbblock.mobile;


import NPartner.Page;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.TextNode;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

import ru.yandex.bolts.collection.Option;
import ru.yandex.partner.core.block.MobileBlockType;
import ru.yandex.partner.core.entity.block.container.BlockBkDictContainer;
import ru.yandex.partner.core.entity.block.model.MobileRtbBlock;
import ru.yandex.partner.core.entity.block.repository.BlockBkFiller;
import ru.yandex.partner.core.entity.custombkoptions.CustomBkOptionsService;

// todo перенести в папку external
@Component
public class MobileRtbBlockBkFiller implements BlockBkFiller<MobileRtbBlock> {

    private final CustomBkOptionsService customBkOptionsService;

    public MobileRtbBlockBkFiller(CustomBkOptionsService customBkOptionsService) {
        this.customBkOptionsService = customBkOptionsService;
    }

    @Override
    public void fillBkData(@NotNull MobileRtbBlock model, @NotNull Page.TPartnerPage.TBlock.Builder bkData,
                           BlockBkDictContainer container) {
        MobileBkFillerUtils.fillCommon(bkData);

        // заполнение специфично для внешних мобилок https://nda.ya.ru/t/xgKej7eR5CT3UB
        if (MobileBlockType.REWARDED.hasType(model)) {
            bkData.getPageImpOptionsBuilder().addEnable("rewarded");

            String customBlockData = customBkOptionsService.set(
                    bkData.getCustomBlockData(),
                    "Reward.CurrencyType",
                    TextNode.valueOf(model.getCurrencyType())
            );

            customBlockData = customBkOptionsService.set(
                    customBlockData,
                    "Reward.CurrencyValue",
                    LongNode.valueOf(Option.ofNullable(model.getCurrencyValue()).orElse(0))
            );

            customBlockData = customBkOptionsService.set(
                    customBlockData,
                    "Reward.Callback",
                    TextNode.valueOf(model.getCallback())
            );

            customBlockData = customBkOptionsService.set(
                    customBlockData,
                    "Reward.Sign",
                    TextNode.valueOf(model.getSign())
            );

            bkData.setCustomBlockData(customBlockData);

        } else {
            bkData.getPageImpOptionsBuilder().addDisable("rewarded");
        }
    }

    @Override
    public Class<MobileRtbBlock> getTypeClass() {
        return MobileRtbBlock.class;
    }
}
