package ru.yandex.partner.core.entity.block.type.rtbblock.mobile

import org.springframework.stereotype.Component
import ru.yandex.partner.core.CoreConstants
import ru.yandex.partner.core.entity.block.model.BaseBlock
import ru.yandex.partner.core.entity.block.model.MobileRtbBlock
import ru.yandex.partner.core.entity.block.type.blocktypeanddsps.ExternalBlockWithBlockTypeAndDspsRules
import ru.yandex.partner.core.entity.block.type.blocktypeanddsps.ExternalBlockWithBlockTypeDspsRewardedRules
import ru.yandex.partner.core.entity.block.type.common.MobileBlockWithCommonFieldsDspRules
import ru.yandex.partner.core.entity.block.type.dspshowvideoandblocktype.MobileBlockWithBlockTypeAndDspsAndCommonShowVideoDspRules
import ru.yandex.partner.core.entity.block.type.dspsshowvideo.ExternalBlockWithBlockTypeAndShowVideoBannerDspRules
import ru.yandex.partner.core.entity.dsp.rules.DspRuleComponent
import ru.yandex.partner.core.entity.dsp.rules.DspRuleContainer
import ru.yandex.partner.core.entity.dsp.rules.DspRuleSet

@Component
class MobileRtbBlockDspRules(
    private val mobileBlockWithCommonFieldsDspRules: MobileBlockWithCommonFieldsDspRules,
    private val blockWithBlockTypeAndShowVideoDspRules: ExternalBlockWithBlockTypeAndShowVideoBannerDspRules,
    private val blockWithBlockTypeAndDspsRules: ExternalBlockWithBlockTypeAndDspsRules,
    private val blockWithBlockTypeDspsRewardedRules: ExternalBlockWithBlockTypeDspsRewardedRules,
    private val blockWithDspsShowVideoAndBlockTypeDspRules: MobileBlockWithBlockTypeAndDspsAndCommonShowVideoDspRules
) : DspRuleComponent<MobileRtbBlock>() {
    override fun getEntireTypeClass(): Class<MobileRtbBlock> {
        return MobileRtbBlock::class.java
    }

    override fun getDspRuleSet(container: DspRuleContainer): DspRuleSet {
        return DspRuleSet()
            .withRuleSet(mobileBlockWithCommonFieldsDspRules.getDspRuleSet(container))
            .withRuleSet(blockWithBlockTypeAndShowVideoDspRules.getDspRuleSet(container))
            .withRuleSet(blockWithBlockTypeAndDspsRules.getDspRuleSet(container))
            .withRuleSet(blockWithBlockTypeDspsRewardedRules.getDspRuleSet(container))
            .withRuleSet(blockWithDspsShowVideoAndBlockTypeDspRules.getDspRuleSet(container))
    }

    override fun fillDspRuleContainer(container: DspRuleContainer, entity: BaseBlock?) {
        mobileBlockWithCommonFieldsDspRules.fillDspRuleContainer(container, entity)
        blockWithBlockTypeAndDspsRules.fillDspRuleContainer(container, entity)
        blockWithBlockTypeAndShowVideoDspRules.fillDspRuleContainer(container, entity)
        blockWithBlockTypeDspsRewardedRules.fillDspRuleContainer(container, entity)
        blockWithDspsShowVideoAndBlockTypeDspRules.fillDspRuleContainer(container, entity)

        container.addDspType(CoreConstants.DspTypes.DSP_MOBILE)
    }
}
