package ru.yandex.partner.core.entity.block.type.rtbblock.mobile.internal

import org.springframework.stereotype.Component
import ru.yandex.partner.core.CoreConstants
import ru.yandex.partner.core.entity.block.model.BaseBlock
import ru.yandex.partner.core.entity.block.model.InternalMobileRtbBlock
import ru.yandex.partner.core.entity.block.type.blocktypeanddsps.InternalBlockWithBlockTypeAndDspsRules
import ru.yandex.partner.core.entity.block.type.blocktypeanddsps.InternalBlockWithBlockTypeDspsRewardedRules
import ru.yandex.partner.core.entity.block.type.common.MobileBlockWithCommonFieldsDspRules
import ru.yandex.partner.core.entity.block.type.dspshowvideoandblocktype.MobileBlockWithBlockTypeAndDspsAndCommonShowVideoDspRules
import ru.yandex.partner.core.entity.block.type.dspsshowvideo.InternalBlockWithBlockTypeAndShowVideoBannerDspRules
import ru.yandex.partner.core.entity.dsp.model.Dsp
import ru.yandex.partner.core.entity.dsp.rules.DspRule
import ru.yandex.partner.core.entity.dsp.rules.DspRuleComponent
import ru.yandex.partner.core.entity.dsp.rules.DspRuleContainer
import ru.yandex.partner.core.entity.dsp.rules.DspRuleSet
import ru.yandex.partner.core.entity.dsp.rules.result.DspRuleResult
import ru.yandex.partner.core.entity.page.model.BasePage
import ru.yandex.partner.dbschema.partner.tables.Dsp.DSP

@Component
class InternalMobileRtbBlockDspRules(
    private val mobileBlockWithCommonFieldsDspRules: MobileBlockWithCommonFieldsDspRules,
    private val blockWithBlockTypeAndShowVideoDspRules: InternalBlockWithBlockTypeAndShowVideoBannerDspRules,
    private val blockWithBlockTypeAndDspsRules: InternalBlockWithBlockTypeAndDspsRules,
    private val blockWithBlockTypeDspsRewardedRules: InternalBlockWithBlockTypeDspsRewardedRules,
    private val blockWithDspsShowVideoAndBlockTypeDspRules: MobileBlockWithBlockTypeAndDspsAndCommonShowVideoDspRules
) : DspRuleComponent<InternalMobileRtbBlock>() {

    override fun getEntireTypeClass(): Class<InternalMobileRtbBlock> {
        return InternalMobileRtbBlock::class.java
    }

    override fun getDspRuleSet(container: DspRuleContainer): DspRuleSet {
        return DspRuleSet()
            .withRuleSet(mobileBlockWithCommonFieldsDspRules.getDspRuleSet(container))
            .withRuleSet(blockWithBlockTypeAndShowVideoDspRules.getDspRuleSet(container))
            .withRuleSet(blockWithBlockTypeAndDspsRules.getDspRuleSet(container))
            .withRuleSet(blockWithBlockTypeDspsRewardedRules.getDspRuleSet(container))
            .withRuleSet(blockWithDspsShowVideoAndBlockTypeDspRules.getDspRuleSet(container))
            .withRuleSet(DspRuleSet().withRule(object : DspRule<BasePage, BaseBlock, Dsp>() {
                override fun defaultDsps(
                    dspRuleContainer: DspRuleContainer?,
                    page: BasePage?,
                    block: BaseBlock?
                ): DspRuleResult {
                    return DspRuleResult.extend(DSP.ID.`in`(CoreConstants.INTERNAL_MOBILE_DEFAULT_DSPS))
                }
            }))
    }

    override fun fillDspRuleContainer(container: DspRuleContainer, entity: BaseBlock?) {
        mobileBlockWithCommonFieldsDspRules.fillDspRuleContainer(container, entity)
        blockWithBlockTypeAndDspsRules.fillDspRuleContainer(container, entity)
        blockWithBlockTypeAndShowVideoDspRules.fillDspRuleContainer(container, entity)
        blockWithBlockTypeDspsRewardedRules.fillDspRuleContainer(container, entity)
        blockWithDspsShowVideoAndBlockTypeDspRules.fillDspRuleContainer(container, entity)

        container.addDspType(CoreConstants.DspTypes.DSP_MOBILE)
    }
}
