package ru.yandex.partner.core.entity.block.type.rtbopts;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.BlockWithRtbOpts;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.entity.block.repository.type.BlockRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.utils.TypeSupportUtils;

@Component
@ParametersAreNonnullByDefault
public class BlockWithRtbOptsRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupportWithMapper<BlockWithRtbOpts> {

    private final JooqMapper<BlockWithRtbOpts> jooqMapper;

    @Autowired
    public BlockWithRtbOptsRepositoryTypeSupport(
            DSLContext dslContext,
            List<BlockRepositoryTypeSupportWithMapper<? super BlockWithRtbOpts>> blockRepositoryTypeSupports) {
        super(dslContext);
        this.jooqMapper = TypeSupportUtils.buildJooqMapper(blockRepositoryTypeSupports, Set.of(BaseBlock.class));

    }

    @Override
    public JooqMapper<BlockWithRtbOpts> getJooqMapper() {
        return jooqMapper;
    }

    @Override
    public Class<BlockWithRtbOpts> getTypeClass() {
        return BlockWithRtbOpts.class;
    }
}
