package ru.yandex.partner.core.entity.block.type.showslider;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

import NPartner.Page;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.partner.core.entity.block.container.BlockBkDictContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithShowSlider;
import ru.yandex.partner.core.entity.block.repository.BlockBkFiller;
import ru.yandex.partner.core.entity.block.repository.type.AbstractBlockRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.holder.ModelPropertiesHolder;
import ru.yandex.partner.core.multitype.repository.EmptyTypeSupportModifyStrategy;
import ru.yandex.partner.core.operation.CoreModelProvider;
import ru.yandex.partner.core.props.CoreModel;
import ru.yandex.partner.core.props.ModelPropertyDefault;

import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonBooleanToLong;
import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonInteger;
import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_RTB;

@Component
@ParametersAreNonnullByDefault
public class BlockWithShowSliderRepositoryTypeSupport
        extends AbstractBlockRepositoryTypeSupportWithMapper<BlockWithShowSlider>
        implements CoreModelProvider<BlockWithShowSlider>, BlockBkFiller<BlockWithShowSlider> {
    public static final Integer DEFAULT_LIMIT = 1;
    private static final CoreModel<BlockWithShowSlider> CORE_MODEL =
            CoreModel.forClass(BlockWithShowSlider.class)
                    .property(ModelPropertyDefault.<BlockWithShowSlider, Boolean>
                                    forProperty(BlockWithShowSlider.SHOW_SLIDER)
                            .withDefaultValueOnAdd(false))
                    .build();
    private final JooqMapper<BlockWithShowSlider> mapper;
    private final ModelPropertiesHolder editableModelProperties;


    @Autowired
    protected BlockWithShowSliderRepositoryTypeSupport(DSLContext dslContext) {
        super(dslContext, new EmptyTypeSupportModifyStrategy<>());
        this.mapper = JooqMapperBuilder.<BlockWithShowSlider>builder()
                .map(jsonBooleanToLong(BlockWithShowSlider.SHOW_SLIDER, CONTEXT_ON_SITE_RTB.OPTS, "show_slider"))
                .map(jsonInteger(BlockWithShowSlider.LIMIT, CONTEXT_ON_SITE_RTB.OPTS, "limit"))
                .build();

        this.editableModelProperties =
                ModelPropertiesHolder.fromModelProperties(new HashSet<>(mapper.getWritableModelProperties()));
    }

    @Override
    public JooqMapper<BlockWithShowSlider> getJooqMapper() {
        return mapper;
    }

    @Override
    public Class<BlockWithShowSlider> getTypeClass() {
        return BlockWithShowSlider.class;
    }

    @Override
    public ModelPropertiesHolder getEditableModelProperties(BlockWithShowSlider model) {
        return editableModelProperties;
    }

    @Override
    public void enrichModelFromOtherTables(DSLContext dslContext, Collection<BlockWithShowSlider> blocks) {
    }

    @Override
    public CoreModel<BlockWithShowSlider> getCoreModel() {
        return CORE_MODEL;
    }

    @Override
    public void fillBkData(@NotNull BlockWithShowSlider model, @NotNull Page.TPartnerPage.TBlock.Builder bkData,
                           BlockBkDictContainer container) {
        if (Boolean.TRUE.equals(model.getShowSlider())) {
            bkData.setDirectLimit(Optional.ofNullable(model.getLimit()).orElse(DEFAULT_LIMIT));
        } else {
            bkData.setDirectLimit(DEFAULT_LIMIT);
        }
    }
}
