package ru.yandex.partner.core.entity.block.type.siteversionandcontextpage;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.Maps;
import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.QueryOpts;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.BlockWithSiteVersionAndContextPage;
import ru.yandex.partner.core.entity.block.service.validation.type.AbstractBlockValidationTypeSupport;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.page.model.ContextPage;
import ru.yandex.partner.core.entity.page.service.PageService;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.core.filter.meta.MetaFilter;
import ru.yandex.partner.core.filter.operator.FilterOperator;

import static ru.yandex.partner.core.entity.block.type.designtemplates.BlockContainerFiller.getUserFeatures;

@ParametersAreNonnullByDefault
@Component
public class BlockWithSiteVersionAndContextPageValidationTypeSupport
        extends AbstractBlockValidationTypeSupport<BlockWithSiteVersionAndContextPage> {

    private final Validator<BlockWithSiteVersionAndContextPage, Defect> validator;
    private final PageService pageService;

    @Autowired
    public BlockWithSiteVersionAndContextPageValidationTypeSupport(
            BlockWithSiteVersionAndContextPageValidationProvider provider,
            PageService pageService) {
        this.validator = provider.validator();
        this.pageService = pageService;
    }

    @Override
    public Class<BlockWithSiteVersionAndContextPage> getTypeClass() {
        return BlockWithSiteVersionAndContextPage.class;
    }

    @Override
    public void fillContainer(BlockContainer container, List<BlockWithSiteVersionAndContextPage> models) {
        var pageIds = models.stream().map(BaseBlock::getPageId).collect(Collectors.toList());
        MetaFilter<BasePage, Long> pageIdFilter = PageFilters.PAGE_ID;
        CoreFilterNode<ContextPage> coreFilterNode = CoreFilterNode.create(pageIdFilter, FilterOperator.IN,
                StreamEx.of(pageIds).collect(Collectors.toList()));
        Set<ModelProperty<?, ?>> pageModelProperties = Set.of(
                ContextPage.ALLOWED_AMP,
                ContextPage.ALLOWED_TURBO,
                ContextPage.ID,
                ContextPage.OWNER
        );
        var pages = pageService.findAll(QueryOpts.forClass(ContextPage.class)
                        .withFilter(coreFilterNode)
                        .withProps(pageModelProperties)
        );

        Map<Long, ContextPage> pagesIndex = Maps.newHashMapWithExpectedSize(pages.size());
        Map<Long, Set<String>> featuresAndOptions = Maps.newHashMapWithExpectedSize(pages.size());

        pages.forEach(p -> pagesIndex.put(p.getId(), p));
        pages.forEach(p -> featuresAndOptions.put(p.getId(), getUserFeatures(p.getOwner())));

        container.setFeaturesAndOptions(featuresAndOptions);
        container.setPages(pagesIndex);
    }

    @Override
    public ValidationResult<List<BlockWithSiteVersionAndContextPage>, Defect> validate(
            BlockContainer container,
            ValidationResult<List<BlockWithSiteVersionAndContextPage>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validator)
                .getResult();
    }
}
