package ru.yandex.partner.core.entity.block.type.siteversionandcontextpage;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.model.RtbBlock;
import ru.yandex.partner.core.entity.block.type.commonshowvideoandstrategy.SiteVersionType;

import static ru.yandex.partner.core.entity.block.type.commonshowvideoandstrategy.SiteVersionType.AMP;
import static ru.yandex.partner.core.entity.block.type.commonshowvideoandstrategy.SiteVersionType.DESKTOP;
import static ru.yandex.partner.core.entity.block.type.commonshowvideoandstrategy.SiteVersionType.MOBILE;
import static ru.yandex.partner.core.entity.block.type.commonshowvideoandstrategy.SiteVersionType.MOBILE_FLOORAD;
import static ru.yandex.partner.core.entity.block.type.commonshowvideoandstrategy.SiteVersionType.MOBILE_FULLSCREEN;
import static ru.yandex.partner.core.entity.block.type.commonshowvideoandstrategy.SiteVersionType.MOBILE_REWARDED;
import static ru.yandex.partner.core.entity.block.type.commonshowvideoandstrategy.SiteVersionType.TURBO;
import static ru.yandex.partner.core.entity.block.type.commonshowvideoandstrategy.SiteVersionType.TURBO_DESKTOP;

@Component
@ParametersAreNonnullByDefault
public class RtbBlockSiteVersionProvider implements SiteVersionProvider<RtbBlock> {

    @Override
    public Set<SiteVersionType> getSiteVersions() {
        return Set.of(
                DESKTOP,
                MOBILE,
                TURBO,
                TURBO_DESKTOP,
                AMP,
                MOBILE_FULLSCREEN,
                MOBILE_REWARDED,
                MOBILE_FLOORAD
        );
    }


    @Override
    public Class<RtbBlock> getTypeClass() {
        return RtbBlock.class;
    }
}
