package ru.yandex.partner.core.entity.block.type.siteversionandcontextpage;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.multitype.typesupport.TypeSupport;
import ru.yandex.partner.core.entity.block.model.BaseBlock;

import static java.util.stream.Collectors.toMap;

@ParametersAreNonnullByDefault
@Component
public class SiteVersionAvailabilityFacade {

    private Map<Class<? extends BaseBlock>, SiteVersionProvider<? extends BaseBlock>> providers;

    public SiteVersionAvailabilityFacade(List<SiteVersionProvider<? extends BaseBlock>> providers) {
        this.providers = providers.stream()
                .collect(toMap(TypeSupport::getTypeClass, Function.identity()));
    }

    public <T extends BaseBlock> SiteVersionProvider<T> getAvailabilityProvider(Class<T> blockClass) {
        return Optional.of((SiteVersionProvider<T>) providers.get(blockClass))
                .orElseThrow(() -> new IllegalArgumentException(
                        "You have to implement site version for %s".formatted(blockClass.getSimpleName()))
                );
    }


}
