package ru.yandex.partner.core.entity.block.type.strategy;

import java.util.Set;

import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.block.BlockType;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.BlockWithStrategy;
import ru.yandex.partner.core.entity.block.service.type.update.AbstractBlockUpdateOperationTypeSupport;
import ru.yandex.partner.core.multitype.repository.PartnerRepositoryTypeSupportFacade;

@Component
public class BlockWithStrategyUpdateOperationTypeSupport
        extends AbstractBlockUpdateOperationTypeSupport<BlockWithStrategy> {
    private static final Set<ModelProperty<? super BlockWithStrategy, ?>> NEED_UPDATE_IN_BK_STRATEGY_FIELDS =
            Set.of(
                    BlockWithStrategy.STRATEGY_TYPE,

                    BlockWithStrategy.MEDIA_ACTIVE,
                    BlockWithStrategy.MEDIA_BLOCKED,
                    BlockWithStrategy.MEDIA_CPM,
                    BlockWithStrategy.MINCPM,
                    BlockWithStrategy.TEXT_ACTIVE,
                    BlockWithStrategy.TEXT_BLOCKED,
                    BlockWithStrategy.TEXT_CPM,
                    BlockWithStrategy.VIDEO_ACTIVE,
                    BlockWithStrategy.VIDEO_BLOCKED,
                    BlockWithStrategy.VIDEO_CPM
            );

    public BlockWithStrategyUpdateOperationTypeSupport(PartnerRepositoryTypeSupportFacade<BaseBlock, BlockType,
            BlockContainer, BlockContainer> repositoryFacade) {
        super(repositoryFacade);
    }

    @Override
    public Set<ModelProperty<? super BlockWithStrategy, ?>> needBsResyncProps() {
        return NEED_UPDATE_IN_BK_STRATEGY_FIELDS;
    }

    @Override
    public Class<BlockWithStrategy> getTypeClass() {
        return BlockWithStrategy.class;
    }
}
