package ru.yandex.partner.core.entity.block.type.tags;

import java.util.Set;

import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.block.BlockType;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.BlockWithTags;
import ru.yandex.partner.core.entity.block.service.type.update.AbstractBlockUpdateOperationTypeSupport;
import ru.yandex.partner.core.multitype.repository.PartnerRepositoryTypeSupportFacade;

@Component
public class BlockWithTagsUpdateOperationTypeSupport
        extends AbstractBlockUpdateOperationTypeSupport<BlockWithTags> {
    private static final Set<ModelProperty<? super BlockWithTags, ?>> NEED_UPDATE_IN_BK_FIELDS = Set.of(
            BlockWithTags.ORDER_TAGS,
            BlockWithTags.TARGET_TAGS
    );

    public BlockWithTagsUpdateOperationTypeSupport(PartnerRepositoryTypeSupportFacade<BaseBlock, BlockType,
            BlockContainer, BlockContainer> repositoryFacade) {
        super(repositoryFacade);
    }

    @Override
    public Class<BlockWithTags> getTypeClass() {
        return BlockWithTags.class;
    }

    @Override
    public Set<ModelProperty<? super BlockWithTags, ?>> needBsResyncProps() {
        return NEED_UPDATE_IN_BK_FIELDS;
    }
}
