package ru.yandex.partner.core.entity.block.type.tags;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithTags;
import ru.yandex.partner.core.entity.block.service.validation.type.AbstractBlockValidationTypeSupport;

@ParametersAreNonnullByDefault
@Component
public class BlockWithTagsValidationTypeSupport extends AbstractBlockValidationTypeSupport<BlockWithTags> {
    private final BlockWithTagsValidatorProvider validatorProvider;
    private final TagService tagsService;

    @Autowired
    public BlockWithTagsValidationTypeSupport(BlockWithTagsValidatorProvider validatorProvider,
                                              TagService tagsService) {

        this.validatorProvider = validatorProvider;
        this.tagsService = tagsService;
    }

    @Override
    public Class<BlockWithTags> getTypeClass() {
        return BlockWithTags.class;
    }

    @Override
    public void fillContainer(BlockContainer container, List<BlockWithTags> blocks) {
        if (container.getAvailableTagIds().isEmpty()) {
            container.setAvailableTagIds(tagsService.getTagIds());
        }
    }

    @Override
    public void fillContainerFullDictionaries(BlockContainer container) {
        container.setAvailableTagIds(tagsService.getTagIds());
    }

    @Override
    public ValidationResult<List<BlockWithTags>, Defect> validate(
            BlockContainer container,
            ValidationResult<List<BlockWithTags>, Defect> vr) {

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.validator(container))
                .getResult();
    }
}
