package ru.yandex.partner.core.entity.block.type.tags;

import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

import com.google.common.collect.Sets;
import one.util.streamex.StreamEx;
import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BlockWithTags;
import ru.yandex.partner.core.entity.block.service.validation.defects.BlockDefectIds;
import ru.yandex.partner.core.entity.block.service.validation.defects.BlockSimpleDefectParam;

@Component
public class BlockWithTagsValidatorProvider {

    public <M extends BlockWithTags> Validator<M, Defect> validator(BlockContainer container) {
        return block -> {
            var vb = ModelItemValidationBuilder.of(block);
            var availableTags = container.getAvailableTagIds();
            Function<List<Long>, Defect> tagChecker = it -> checkTags(availableTags, it);
            vb.item(BlockWithTags.ORDER_TAGS).checkByFunction(tagChecker, When.notNull());
            vb.item(BlockWithTags.TARGET_TAGS).checkByFunction(tagChecker, When.notNull());
            return vb.getResult();
        };
    }

    private Defect<BlockSimpleDefectParam> checkTags(Set<Long> availableTags, List<Long> it) {
        var notExistedTagIds = Sets.difference(StreamEx.of(it).collect(Collectors.toSet()), availableTags);
        if (!notExistedTagIds.isEmpty()) {
            return new Defect<>(BlockDefectIds.OptsDefectIds.NON_EXISTED_TAGS,
                    new BlockSimpleDefectParam().withParam(notExistedTagIds.stream()
                            .map(String::valueOf).collect(Collectors.joining(","))));
        }
        return null;
    }


}
