package ru.yandex.partner.core.entity.blockseq;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.partner.core.block.BlockUniqueIdConverter;
import ru.yandex.partner.core.entity.block.model.InternalRtbBlock;
import ru.yandex.partner.core.entity.block.model.MobileRtbBlock;
import ru.yandex.partner.core.entity.block.model.RtbBlock;
import ru.yandex.partner.core.entity.blockseq.model.ExternalContextBlockSeq;
import ru.yandex.partner.core.entity.blockseq.model.InternalContextBlockSeq;
import ru.yandex.partner.core.entity.blockseq.model.InternalMobileAppBlockSeq;
import ru.yandex.partner.core.entity.blockseq.model.MobileAppBlockSeq;
import ru.yandex.partner.dbschema.partner.tables.records.ContextOnSiteBlockSeqRecord;
import ru.yandex.partner.dbschema.partner.tables.records.InternalContextOnSiteBlockSeqRecord;
import ru.yandex.partner.dbschema.partner.tables.records.InternalMobileAppBlockSeqRecord;
import ru.yandex.partner.dbschema.partner.tables.records.MobileAppBlockSeqRecord;

@Configuration
public class BlockSeqServiceConfiguration {

    @Bean
    public SimpleBlockSequenceService<ExternalContextBlockSeq, ContextOnSiteBlockSeqRecord>
    extContextBlockSeqService(ExternalContextBlockSeqRepository repository) {
        return new SimpleBlockSequenceService<>(
                repository,
                BlockUniqueIdConverter.Prefixes.CONTEXT_ON_SITE_RTB_PREFIX,
                RtbBlock.class
        );
    }

    @Bean
    public SimpleBlockSequenceService<InternalContextBlockSeq, InternalContextOnSiteBlockSeqRecord>
    intContextBlockSeqService(InternalContextBlockSeqRepository repository) {
        return new SimpleBlockSequenceService<>(
                repository,
                BlockUniqueIdConverter.Prefixes.INTERNAL_CONTEXT_ON_SITE_RTB_PREFIX,
                InternalRtbBlock.class
        );
    }

    @Bean
    public SimpleBlockSequenceService<MobileAppBlockSeq, MobileAppBlockSeqRecord>
    mobileBlockSeqService(MobileAppBlockSeqRepository repository) {
        return new SimpleBlockSequenceService<>(
                repository,
                BlockUniqueIdConverter.Prefixes.MOBILE_RTB_PREFIX,
                MobileRtbBlock.class
        );
    }


    @Bean
    public SimpleBlockSequenceService<InternalMobileAppBlockSeq, InternalMobileAppBlockSeqRecord>
    internalMobileBlockSeqService(InternalMobileAppBlockSeqRepository repository) {
        return new SimpleBlockSequenceService<>(
                repository,
                BlockUniqueIdConverter.Prefixes.INTERNAL_MOBILE_RTB_PREFIX,
                MobileRtbBlock.class
        );
    }
}
