package ru.yandex.partner.core.entity.blockseq;

import org.jooq.TableField;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.blockseq.model.ExternalContextBlockSeq;
import ru.yandex.partner.dbschema.partner.tables.records.ContextOnSiteBlockSeqRecord;

import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_BLOCK_SEQ;

@Component
public class ExternalContextBlockSeqFieldsProvider
        implements BlockSequenceFieldsProvider<ExternalContextBlockSeq, ContextOnSiteBlockSeqRecord> {

    @Override
    public TableField<ContextOnSiteBlockSeqRecord, Long> getPageIdField() {
        return CONTEXT_ON_SITE_BLOCK_SEQ.CAMPAIGN_ID;
    }

    @Override
    public TableField<ContextOnSiteBlockSeqRecord, Long> getNextBlockIdField() {
        return CONTEXT_ON_SITE_BLOCK_SEQ.NEXT_BLOCK_ID;
    }

    @Override
    public ExternalContextBlockSeq getBlockSeqInstance() {
        return new ExternalContextBlockSeq();
    }
}
