package ru.yandex.partner.core.entity.blockseq;

import org.jooq.DSLContext;
import org.jooq.impl.TableImpl;
import org.springframework.stereotype.Repository;

import ru.yandex.partner.core.entity.blockseq.filter.ExternalContextBlockSeqModelFilterContainer;
import ru.yandex.partner.core.entity.blockseq.model.ExternalContextBlockSeq;
import ru.yandex.partner.dbschema.partner.tables.records.ContextOnSiteBlockSeqRecord;

import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_BLOCK_SEQ;

@Repository
public class ExternalContextBlockSeqRepository
        extends BlockSequenceRepository<ExternalContextBlockSeq, ContextOnSiteBlockSeqRecord> {
    public ExternalContextBlockSeqRepository(
            DSLContext dslContext,
            BlockSequenceFieldsProvider<ExternalContextBlockSeq, ContextOnSiteBlockSeqRecord>
                    blockSequenceFieldsProvider,
            ExternalContextBlockSeqModelFilterContainer metaFilterService
    ) {
        super(dslContext, blockSequenceFieldsProvider, metaFilterService);
    }

    @Override
    protected TableImpl<ContextOnSiteBlockSeqRecord> getTable() {
        return CONTEXT_ON_SITE_BLOCK_SEQ;
    }

    @Override
    protected Class<ExternalContextBlockSeq> getModelClass() {
        return ExternalContextBlockSeq.class;
    }
}
