package ru.yandex.partner.core.entity.blockseq;

import org.jooq.TableField;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.blockseq.model.InternalContextBlockSeq;
import ru.yandex.partner.dbschema.partner.tables.records.InternalContextOnSiteBlockSeqRecord;

import static ru.yandex.partner.dbschema.partner.Tables.INTERNAL_CONTEXT_ON_SITE_BLOCK_SEQ;

@Component
public class InternalContextBlockSeqFieldsProvider implements
        BlockSequenceFieldsProvider<InternalContextBlockSeq, InternalContextOnSiteBlockSeqRecord> {
    @Override
    public TableField<InternalContextOnSiteBlockSeqRecord, Long> getPageIdField() {
        return INTERNAL_CONTEXT_ON_SITE_BLOCK_SEQ.CAMPAIGN_ID;
    }

    @Override
    public TableField<InternalContextOnSiteBlockSeqRecord, Long> getNextBlockIdField() {
        return INTERNAL_CONTEXT_ON_SITE_BLOCK_SEQ.NEXT_BLOCK_ID;
    }

    @Override
    public InternalContextBlockSeq getBlockSeqInstance() {
        return new InternalContextBlockSeq();
    }
}
