package ru.yandex.partner.core.entity.blockseq;

import org.jooq.DSLContext;
import org.jooq.impl.TableImpl;
import org.springframework.stereotype.Repository;

import ru.yandex.partner.core.entity.blockseq.filter.InternalContextBlockSeqModelFilterContainer;
import ru.yandex.partner.core.entity.blockseq.model.InternalContextBlockSeq;
import ru.yandex.partner.dbschema.partner.tables.records.InternalContextOnSiteBlockSeqRecord;

import static ru.yandex.partner.dbschema.partner.Tables.INTERNAL_CONTEXT_ON_SITE_BLOCK_SEQ;

@Repository
public class InternalContextBlockSeqRepository
        extends BlockSequenceRepository<InternalContextBlockSeq, InternalContextOnSiteBlockSeqRecord> {

    public InternalContextBlockSeqRepository(
            DSLContext dslContext,
            BlockSequenceFieldsProvider<InternalContextBlockSeq, InternalContextOnSiteBlockSeqRecord>
                    blockSequenceFieldsProvider,
            InternalContextBlockSeqModelFilterContainer metaFilterService
    ) {
        super(dslContext, blockSequenceFieldsProvider, metaFilterService);
    }

    @Override
    protected TableImpl<InternalContextOnSiteBlockSeqRecord> getTable() {
        return INTERNAL_CONTEXT_ON_SITE_BLOCK_SEQ;
    }

    @Override
    protected Class<InternalContextBlockSeq> getModelClass() {
        return InternalContextBlockSeq.class;
    }
}
