package ru.yandex.partner.core.entity.blockseq;

import org.jooq.TableField;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.blockseq.model.InternalMobileAppBlockSeq;
import ru.yandex.partner.dbschema.partner.tables.records.InternalMobileAppBlockSeqRecord;

import static ru.yandex.partner.dbschema.partner.Tables.INTERNAL_MOBILE_APP_BLOCK_SEQ;

@Component
public class InternalMobileAppBlockSeqFieldsProvider implements
        BlockSequenceFieldsProvider<InternalMobileAppBlockSeq, InternalMobileAppBlockSeqRecord> {
    @Override
    public TableField<InternalMobileAppBlockSeqRecord, Long> getPageIdField() {
        return INTERNAL_MOBILE_APP_BLOCK_SEQ.APPLICATION_ID;
    }

    @Override
    public TableField<InternalMobileAppBlockSeqRecord, Long> getNextBlockIdField() {
        return INTERNAL_MOBILE_APP_BLOCK_SEQ.NEXT_BLOCK_ID;
    }

    @Override
    public InternalMobileAppBlockSeq getBlockSeqInstance() {
        return new InternalMobileAppBlockSeq();
    }
}
