package ru.yandex.partner.core.entity.blockseq;

import org.jooq.DSLContext;
import org.jooq.impl.TableImpl;
import org.springframework.stereotype.Repository;

import ru.yandex.partner.core.entity.blockseq.filter.InternalMobileAppBlockSeqModelFilterContainer;
import ru.yandex.partner.core.entity.blockseq.model.InternalMobileAppBlockSeq;
import ru.yandex.partner.dbschema.partner.tables.records.InternalMobileAppBlockSeqRecord;

import static ru.yandex.partner.dbschema.partner.Tables.INTERNAL_MOBILE_APP_BLOCK_SEQ;

@Repository
public class InternalMobileAppBlockSeqRepository
        extends BlockSequenceRepository<InternalMobileAppBlockSeq, InternalMobileAppBlockSeqRecord> {

    public InternalMobileAppBlockSeqRepository(
            DSLContext dslContext,
            BlockSequenceFieldsProvider<InternalMobileAppBlockSeq, InternalMobileAppBlockSeqRecord>
                    blockSequenceFieldsProvider,
            InternalMobileAppBlockSeqModelFilterContainer metaFilterService
    ) {
        super(dslContext, blockSequenceFieldsProvider, metaFilterService);
    }

    @Override
    protected TableImpl<InternalMobileAppBlockSeqRecord> getTable() {
        return INTERNAL_MOBILE_APP_BLOCK_SEQ;
    }

    @Override
    protected Class<InternalMobileAppBlockSeq> getModelClass() {
        return InternalMobileAppBlockSeq.class;
    }
}
