package ru.yandex.partner.core.entity.blockseq;

import org.jooq.TableField;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.blockseq.model.MobileAppBlockSeq;
import ru.yandex.partner.dbschema.partner.tables.records.MobileAppBlockSeqRecord;

import static ru.yandex.partner.dbschema.partner.Tables.MOBILE_APP_BLOCK_SEQ;

@Component
public class MobileAppBlockSeqFieldsProvider implements
        BlockSequenceFieldsProvider<MobileAppBlockSeq, MobileAppBlockSeqRecord> {
    @Override
    public TableField<MobileAppBlockSeqRecord, Long> getPageIdField() {
        return MOBILE_APP_BLOCK_SEQ.CONTEXT_PAGE_ID;
    }

    @Override
    public TableField<MobileAppBlockSeqRecord, Long> getNextBlockIdField() {
        return MOBILE_APP_BLOCK_SEQ.NEXT_BLOCK_ID;
    }

    @Override
    public MobileAppBlockSeq getBlockSeqInstance() {
        return new MobileAppBlockSeq();
    }
}
