package ru.yandex.partner.core.entity.blockseq;

import org.jooq.DSLContext;
import org.jooq.impl.TableImpl;
import org.springframework.stereotype.Repository;

import ru.yandex.partner.core.entity.blockseq.filter.MobileAppBlockSeqModelFilterContainer;
import ru.yandex.partner.core.entity.blockseq.model.MobileAppBlockSeq;
import ru.yandex.partner.dbschema.partner.tables.records.MobileAppBlockSeqRecord;

import static ru.yandex.partner.dbschema.partner.Tables.MOBILE_APP_BLOCK_SEQ;

@Repository
public class MobileAppBlockSeqRepository
        extends BlockSequenceRepository<MobileAppBlockSeq, MobileAppBlockSeqRecord> {

    public MobileAppBlockSeqRepository(
            DSLContext dslContext,
            BlockSequenceFieldsProvider<MobileAppBlockSeq, MobileAppBlockSeqRecord>
                    blockSequenceFieldsProvider,
            MobileAppBlockSeqModelFilterContainer metaFilterService
    ) {
        super(dslContext, blockSequenceFieldsProvider, metaFilterService);
    }

    @Override
    protected TableImpl<MobileAppBlockSeqRecord> getTable() {
        return MOBILE_APP_BLOCK_SEQ;
    }

    @Override
    protected Class<MobileAppBlockSeq> getModelClass() {
        return MobileAppBlockSeq.class;
    }
}
