package ru.yandex.partner.core.entity.blockseq.filter;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.partner.core.entity.blockseq.model.ExternalContextBlockSeq;
import ru.yandex.partner.core.filter.container.CommonModelFilterContainer;
import ru.yandex.partner.core.filter.db.NumberDbFilter;
import ru.yandex.partner.dbschema.partner.Tables;

@Service
public class ExternalContextBlockSeqModelFilterContainer extends CommonModelFilterContainer<ExternalContextBlockSeq> {

    @Autowired
    public ExternalContextBlockSeqModelFilterContainer() {
        super(List.of(new NumberDbFilter<>(
                BlockSequenceFilters.PAGE_ID, ExternalContextBlockSeq.class,
                Tables.CONTEXT_ON_SITE_BLOCK_SEQ.CAMPAIGN_ID)));
    }

    @Override
    public Class<ExternalContextBlockSeq> getModelClass() {
        return ExternalContextBlockSeq.class;
    }
}
