package ru.yandex.partner.core.entity.blockseq.filter;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.partner.core.entity.blockseq.model.InternalContextBlockSeq;
import ru.yandex.partner.core.filter.container.CommonModelFilterContainer;
import ru.yandex.partner.core.filter.db.NumberDbFilter;
import ru.yandex.partner.dbschema.partner.Tables;

@Service
public class InternalContextBlockSeqModelFilterContainer extends CommonModelFilterContainer<InternalContextBlockSeq> {

    @Autowired
    public InternalContextBlockSeqModelFilterContainer() {
        super(List.of(new NumberDbFilter<>(
                BlockSequenceFilters.PAGE_ID, InternalContextBlockSeq.class,
                Tables.INTERNAL_CONTEXT_ON_SITE_BLOCK_SEQ.CAMPAIGN_ID)));
    }

    @Override
    public Class<InternalContextBlockSeq> getModelClass() {
        return InternalContextBlockSeq.class;
    }
}
