package ru.yandex.partner.core.entity.blockseq.filter;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.partner.core.entity.blockseq.model.InternalMobileAppBlockSeq;
import ru.yandex.partner.core.filter.container.CommonModelFilterContainer;
import ru.yandex.partner.core.filter.db.NumberDbFilter;
import ru.yandex.partner.dbschema.partner.Tables;

@Service
public class InternalMobileAppBlockSeqModelFilterContainer
        extends CommonModelFilterContainer<InternalMobileAppBlockSeq> {

    @Autowired
    public InternalMobileAppBlockSeqModelFilterContainer() {
        super(List.of(new NumberDbFilter<>(
                BlockSequenceFilters.PAGE_ID, InternalMobileAppBlockSeq.class,
                Tables.INTERNAL_MOBILE_APP_BLOCK_SEQ.APPLICATION_ID)));
    }

    @Override
    public Class<InternalMobileAppBlockSeq> getModelClass() {
        return InternalMobileAppBlockSeq.class;
    }
}
