package ru.yandex.partner.core.entity.blockseq.filter;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.partner.core.entity.blockseq.model.MobileAppBlockSeq;
import ru.yandex.partner.core.filter.container.CommonModelFilterContainer;
import ru.yandex.partner.core.filter.db.NumberDbFilter;
import ru.yandex.partner.dbschema.partner.Tables;

@Service
public class MobileAppBlockSeqModelFilterContainer extends CommonModelFilterContainer<MobileAppBlockSeq> {

    @Autowired
    public MobileAppBlockSeqModelFilterContainer() {
        super(List.of(new NumberDbFilter<>(
                BlockSequenceFilters.PAGE_ID, MobileAppBlockSeq.class,
                Tables.MOBILE_APP_BLOCK_SEQ.CONTEXT_PAGE_ID)));
    }

    @Override
    public Class<MobileAppBlockSeq> getModelClass() {
        return MobileAppBlockSeq.class;
    }
}
