package ru.yandex.partner.core.entity.brand;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.TableField;
import org.springframework.stereotype.Repository;

import ru.yandex.partner.core.entity.DictRepository;
import ru.yandex.partner.dbschema.partner.tables.TnsDictBrand;
import ru.yandex.partner.dbschema.partner.tables.records.TnsDictBrandRecord;

import static ru.yandex.partner.dbschema.partner.tables.TnsDictBrand.TNS_DICT_BRAND;

@Repository
@ParametersAreNonnullByDefault
public class TnsDictBrandRepository extends DictRepository<TnsDictBrandRecord> {

    @Override
    @Nonnull
    protected TnsDictBrand getTable() {
        return TNS_DICT_BRAND;
    }

    @Override
    @Nonnull
    protected TableField<TnsDictBrandRecord, Long> getIdField() {
        return getTable().BID;
    }
}
