package ru.yandex.partner.core.entity.common.editablefields

import ru.yandex.direct.model.AppliedChanges
import ru.yandex.direct.model.ModelChanges
import ru.yandex.direct.model.ModelWithId
import ru.yandex.direct.multitype.service.type.update.UpdateOperationContainer
import ru.yandex.direct.multitype.typesupport.TypeSupportAffectionHelper
import ru.yandex.partner.core.holder.ModelPropertiesHolder
import ru.yandex.partner.core.multitype.repository.PartnerRepositoryTypeSupport
import ru.yandex.partner.core.multitype.repository.PartnerRepositoryTypeSupportFacade

open class EditableFieldsService<B : ModelWithId>(
    private val repositoryTypeSupportFacade: PartnerRepositoryTypeSupportFacade<B, out Any, out Any, out Any>,
    private val typeSupportAffectionHelper: TypeSupportAffectionHelper<B>

) {
    /**
     * Вычисляет editable fields в зависимости от изменений, в случае
     * необходимости вычислить все нужно не передавать изменения
     */
    fun <T : B> calculateEditableModelPropertiesHolder(model: T, changes: AppliedChanges<T>? = null): ModelPropertiesHolder {

        val allSupports = repositoryTypeSupportFacade.getSupportsByClass(model.javaClass)
        val affectedSupports = changes?.let {
            allSupports.filter { support ->
                typeSupportAffectionHelper.isAppliedChangesAffectsSupport(it, support.typeClass)
            }
        } ?: allSupports

        return if (affectedSupports.isEmpty()) {
            ModelPropertiesHolder()
        } else {
            affectedSupports.map { getEditableModelPropertiesFromSupport(it, model) }
                .reduce { holder1, holder2 -> holder1.merge(holder2) }
        }
    }

    fun <T : B> calculateEditableModelPropertiesHolder(model: T, container: UpdateOperationContainer<B>,
                                                       mc: ModelChanges<T>? = null): ModelPropertiesHolder {
        val allSupports = repositoryTypeSupportFacade.getSupportsByClass(model.javaClass)
        val affectedSupports = mc?.let {
            allSupports.filter { support ->
                typeSupportAffectionHelper.isModelChangesAffectsSupport(container, it, support.typeClass)
            }
        } ?: allSupports

        return if (affectedSupports.isEmpty()) {
            ModelPropertiesHolder()
        } else {
            affectedSupports.map { getEditableModelPropertiesFromSupport(it, model) }
                .reduce { holder1, holder2 -> holder1.merge(holder2) }
        }
    }

    private fun <T : B> getEditableModelPropertiesFromSupport(
        support: PartnerRepositoryTypeSupport<T, out Any, out Any>,
        model: B
    ): ModelPropertiesHolder {
        @Suppress("UNCHECKED_CAST")
        return support.getEditableModelProperties(model as T)
    }

}
