package ru.yandex.partner.core.entity.common.utils;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.service.OperationMode;
import ru.yandex.partner.core.entity.common.ModelWithBlockPageIds;

@ParametersAreNonnullByDefault
public class ModelWithBlockPageIdsUtils {

    private ModelWithBlockPageIdsUtils() {
    }

    public static <M extends ModelWithBlockPageIds> void setPageBlockIds(@Nullable List<M> models,
                                                                         BaseBlock baseBlock,
                                                                         OperationMode mode) {
        if (models == null) {
            return;
        }

        models.forEach(it -> setPageBlockIds(it, baseBlock, mode));
    }

    public static <M extends ModelWithBlockPageIds> void setPageBlockIds(@Nullable M model,
                                                                         BaseBlock baseBlock,
                                                                         OperationMode mode) {

        if (model == null) {
            return;
        }

        if (mode.equals(OperationMode.DUPLICATE) || model.getBlockId() == null) {
            model.setBlockId(baseBlock.getBlockId());
        }
        if (model.getPageId() == null) {
            model.setPageId(baseBlock.getPageId());
        }

    }

    public static <M extends ModelWithBlockPageIds> void clearPageBlockIds(@Nullable List<M> models) {
        if (models == null) {
            return;
        }
        models.forEach(ModelWithBlockPageIdsUtils::clearPageBlockIds);
    }

    public static <M extends ModelWithBlockPageIds> void clearPageBlockIds(@Nullable M model) {
        if (model == null) {
            return;
        }
        model.setBlockId(null);
        model.setPageId(null);
    }

}
