package ru.yandex.partner.core.entity.common.validation;

import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;
import ru.yandex.partner.core.entity.common.ModelWithBlockPageIds;

import static ru.yandex.direct.validation.constraint.CommonConstraints.isNull;


@Component
public class ModelWithBlockPageIdValidatorProvider<M extends ModelWithBlockPageIds> {

    public Validator<M, Defect> addPreValidator() {
        return model -> {
            var vr = ModelItemValidationBuilder.of(model);
            vr.item(ModelWithBlockPageIds.BLOCK_ID).check(isNull());
            vr.item(ModelWithBlockPageIds.PAGE_ID).check(isNull());
            return vr.getResult();
        };
    }

}
