package ru.yandex.partner.core.entity.common.validation;

import java.util.Collection;

import org.springframework.stereotype.Component;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.isNull;

/**
 * Класс генерит валидатор при добавлении - проверка тех
 * параметров которые должны быть null
 * передается список параметров на проверку
 */
@Component
public class NullPropertiesValidatorProvider<M extends Model> {

    public Validator<M, Defect> addPreValidator(Collection<ModelProperty<? super M, ?>> properties) {
        return model -> {
            var vr = ModelItemValidationBuilder.of(model);
            properties.forEach(prop ->
                    vr.item(prop).check(isNull()));
            return vr.getResult();
        };
    }

}
