package ru.yandex.partner.core.entity.crimea;

import java.util.List;
import java.util.Map;

import org.jooq.DSLContext;
import org.springframework.stereotype.Service;

import ru.yandex.partner.core.CoreConstants;
import ru.yandex.partner.dbschema.partner.tables.AllPages;
import ru.yandex.partner.dbschema.partner.tables.Users;

@Service
public class CrimeaRepository {

    private final DSLContext dslContext;

    public CrimeaRepository(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    public Map<Long, Boolean> getPageIdsToIsCrimeaRussian(List<Long> pageIds) {
        // todo переписать на AllPages
        return dslContext.select(AllPages.ALL_PAGES.PAGE_ID, Users.USERS.COUNTRY_ID)
                .from(AllPages.ALL_PAGES.join(Users.USERS).on(AllPages.ALL_PAGES.OWNER_ID.eq(Users.USERS.ID)))
                .where(AllPages.ALL_PAGES.PAGE_ID.in(pageIds).and(Users.USERS.COUNTRY_ID.isNotNull()))
                .fetchMap(AllPages.ALL_PAGES.PAGE_ID,
                        record -> CoreConstants.CRIMEA_TO_RUSSIA.contains(record.get(Users.USERS.COUNTRY_ID)));
    }
}
