package ru.yandex.partner.core.entity.custombkoptions;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.custombkoptions.model.CustomBkOptions;
import ru.yandex.partner.core.messages.CustomBkOptionsActionMsg;
import ru.yandex.partner.core.multistate.Multistate;
import ru.yandex.partner.core.multistate.custombkoptions.CustomBkOptionsMultistate;
import ru.yandex.partner.core.multistate.custombkoptions.CustomBkOptionsStateFlag;
import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.multistate.action.ActionEntry;
import ru.yandex.partner.libs.multistate.action.ActionNameHolder;
import ru.yandex.partner.libs.multistate.graph.AbstractMultistateGraph;

import static java.util.function.Predicate.not;
import static ru.yandex.partner.libs.multistate.MultistatePredicates.empty;
import static ru.yandex.partner.libs.multistate.MultistatePredicates.has;

@Component
public class CustomBkOptionsMultistateGraph extends AbstractMultistateGraph<CustomBkOptions, CustomBkOptionsStateFlag> {

    @Override
    public Multistate<CustomBkOptionsStateFlag> getMultistateFromModel(CustomBkOptions model) {
        return model.getMultistate();
    }

    @Override
    protected Map<ActionNameHolder, ActionEntry<CustomBkOptions, CustomBkOptionsStateFlag>> createGraph() {
        return Map.ofEntries(
                Map.entry(
                        CustomBkOptionsActionsEnum.ADD,
                        getActionEntryBuilder(CustomBkOptionsActionMsg.ADD)
                                .setPredicate(empty())
                                .build()
                ),
                Map.entry(
                        CustomBkOptionsActionsEnum.EDIT,
                        getActionEntryBuilder(CustomBkOptionsActionMsg.EDIT)
                                .setPredicate(empty())
                                .build()
                ),
                Map.entry(
                        CustomBkOptionsActionsEnum.DELETE,
                        getActionEntryBuilder(CustomBkOptionsActionMsg.DELETE)
                                .setPredicate(not(has(CustomBkOptionsStateFlag.DELETED)))
                                .setSetFlags(
                                        Map.of(
                                                CustomBkOptionsStateFlag.DELETED, true
                                        )
                                )
                                .build()
                ),
                Map.entry(
                        CustomBkOptionsActionsEnum.RESTORE,
                        getActionEntryBuilder(CustomBkOptionsActionMsg.RESTORE)
                                .setPredicate(has(CustomBkOptionsStateFlag.DELETED))
                                .setSetFlags(
                                        Map.of(
                                                CustomBkOptionsStateFlag.DELETED, false
                                        )
                                )
                                .build()
                )
        );
    }

    @Override
    protected Multistate<CustomBkOptionsStateFlag> getMultistateForValue(Long multistateValue) {
        return new CustomBkOptionsMultistate(multistateValue);
    }

    private ActionEntry.Builder<CustomBkOptions, CustomBkOptionsStateFlag> getActionEntryBuilder(GettextMsg titleMsg) {
        return getActionEntryBuilder(titleMsg, Set.of(CustomBkOptions.ID, CustomBkOptions.MULTISTATE));
    }

    @Override
    public Class<CustomBkOptions> getModelClass() {
        return CustomBkOptions.class;
    }

    @Override
    public Multistate<CustomBkOptionsStateFlag> convertMultistate(List<CustomBkOptionsStateFlag> enabledFlags) {
        return new CustomBkOptionsMultistate(enabledFlags);
    }
}
