package ru.yandex.partner.core.entity.custombkoptions;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Record;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.custombkoptions.container.CustomBkOptionsRepositoryContainer;
import ru.yandex.partner.core.entity.custombkoptions.model.CustomBkOptions;
import ru.yandex.partner.core.entity.custombkoptions.repository.CustomBkOptionsRepositoryTypeSupport;
import ru.yandex.partner.core.multitype.repository.PartnerRepositoryTypeSupportFacade;

@Component
@ParametersAreNonnullByDefault
public class CustomBkOptionsRepositoryTypeSupportFacade
        extends PartnerRepositoryTypeSupportFacade
        <CustomBkOptions, Long, CustomBkOptionsRepositoryContainer, CustomBkOptionsRepositoryContainer> {

    /**
     * Если саппорт навешен на класс, который есть в этом белом списке или на класс, который наследуются от класса,
     * который есть в этом белом списке - то такой саппорт будет вызываться всегда, независимо от изменившихся данных.
     */
    public static final Set<Class<? extends CustomBkOptions>> TYPE_SUPPORT_CLASS_WHITE_LIST = Set.of(
            CustomBkOptions.class
    );


    public CustomBkOptionsRepositoryTypeSupportFacade(
            List<CustomBkOptionsRepositoryTypeSupport<? extends CustomBkOptions>> typeSupports) {

        super(typeSupports, CustomBkOptions::new, TYPE_SUPPORT_CLASS_WHITE_LIST);
    }

    @Override
    protected Long getModelType(Record record) {
        return 0L;
    }

}
