package ru.yandex.partner.core.entity.custombkoptions;

import java.util.Set;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.custombkoptions.model.CustomBkOptions;
import ru.yandex.partner.core.entity.custombkoptions.repository.AbstractCustomBkOptionsRepositoryRepositoryTypeSupport;
import ru.yandex.partner.core.entity.custombkoptions.repository.CustomBkOptionsRepositoryTypeSupportWithMapper;
import ru.yandex.partner.core.multistate.AbstractMultistate;
import ru.yandex.partner.core.multistate.custombkoptions.CustomBkOptionsMultistate;

import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.partner.dbschema.partner.Tables.CUSTOM_BK_OPTIONS;


@Component
@ParametersAreNonnullByDefault
public class CustomBkOptionsRepositoryTypeSupportImpl
        extends AbstractCustomBkOptionsRepositoryRepositoryTypeSupport<CustomBkOptions>
        implements CustomBkOptionsRepositoryTypeSupportWithMapper<CustomBkOptions> {

    private final Set<ModelProperty<? super CustomBkOptions, ?>> affectedModelProperties;
    private final JooqMapper<CustomBkOptions> jooqMapper;

    public CustomBkOptionsRepositoryTypeSupportImpl(DSLContext dslContext) {
        super(dslContext);
        affectedModelProperties = CustomBkOptions.allModelProperties()
                .stream()
                .map(modelProperty -> (ModelProperty<? super CustomBkOptions, ?>) modelProperty)
                .collect(Collectors.toSet());

        jooqMapper = JooqMapperBuilder.<CustomBkOptions>builder()
                .map(property(CustomBkOptions.ID, CUSTOM_BK_OPTIONS.ID))
                .map(property(CustomBkOptions.BK_NAME, CUSTOM_BK_OPTIONS.BK_NAME))
                .map(convertibleProperty(CustomBkOptions.MULTISTATE, CUSTOM_BK_OPTIONS.MULTISTATE,
                        CustomBkOptionsMultistate::new, AbstractMultistate::toMultistateValue))
                .map(property(CustomBkOptions.NAME, CUSTOM_BK_OPTIONS.NAME))
                .map(property(CustomBkOptions.DESCRIPTION, CUSTOM_BK_OPTIONS.DESCRIPTION))
                .map(property(CustomBkOptions.BK_VALUE, CUSTOM_BK_OPTIONS.BK_VALUE))
                .build();
    }

    @Override
    public Set<ModelProperty<? super CustomBkOptions, ?>> getAffectedModelProperties() {
        return affectedModelProperties;
    }

    @Override
    public JooqMapper<CustomBkOptions> getJooqMapper() {
        return jooqMapper;
    }

    @Override
    public Class<CustomBkOptions> getTypeClass() {
        return CustomBkOptions.class;
    }
}
