package ru.yandex.partner.core.entity.custombkoptions;

import java.util.Arrays;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import ru.yandex.partner.core.entity.custombkoptions.model.CustomBkOptions;

@Service
public class CustomBkOptionsService {

    private static final Logger LOGGER = LoggerFactory.getLogger(CustomBkOptionsService.class);
    private final ObjectMapper objectMapper;

    public CustomBkOptionsService(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public String setOption(@Nullable String customBlockData, CustomBkOptions option) {
        ObjectNode customBkDataRoot = getRoot(customBlockData);
        try {
            JsonNode bkValue = objectMapper.readTree(option.getBkValue());
            setInternal(customBkDataRoot, option.getBkName(), bkValue);
        } catch (JsonProcessingException e) {
            LOGGER.error("Can't deserialize bkValue: " + e.getMessage());
        }

        return customBkDataRoot.toString();
    }

    public String set(@Nullable String customBlockData, String dotSeparatedPath, JsonNode node) {
        ObjectNode customBkDataRoot = getRoot(customBlockData);
        setInternal(customBkDataRoot, dotSeparatedPath, node);

        return customBkDataRoot.toString();
    }

    private void setInternal(ObjectNode customBkDataRoot, String dotSeparatedPath, JsonNode jsonNode) {
        String[] path = dotSeparatedPath.split("\\.");
        String optionPropName = path[path.length - 1];

        ObjectNode customBkDataLeaf = customBkDataRoot;
        for (var propertyName: Arrays.copyOfRange(path, 0, path.length - 1)) { // without last
            customBkDataLeaf = customBkDataLeaf.with(propertyName);
        }
        customBkDataLeaf.set(optionPropName, jsonNode);
    }

    private ObjectNode getRoot(@Nullable String customBlockData) {
        if (Strings.isNullOrEmpty(customBlockData)) {
            return objectMapper.createObjectNode();
        }
        try {
            return (ObjectNode) objectMapper.readTree(customBlockData);
        } catch (JsonProcessingException e) {
            LOGGER.warn("Can't read custom block data " + e.getMessage());
            return objectMapper.createObjectNode();
        }
    }
}
