package ru.yandex.partner.core.entity.custombkoptions;

import java.util.Collection;
import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Table;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.multitype.repository.filter.Filter;
import ru.yandex.partner.core.entity.QueryOpts;
import ru.yandex.partner.core.entity.custombkoptions.container.CustomBkOptionsRepositoryContainer;
import ru.yandex.partner.core.entity.custombkoptions.filter.CustomBkOptionsFilterFactory;
import ru.yandex.partner.core.entity.custombkoptions.filter.CustomBkOptionsModelFilterContainer;
import ru.yandex.partner.core.entity.custombkoptions.model.CustomBkOptions;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.core.multitype.repository.PartnerTypedRepository;

import static ru.yandex.partner.dbschema.partner.Tables.CUSTOM_BK_OPTIONS;

@Component
@ParametersAreNonnullByDefault
public class CustomBkOptionsTypedRepository
        extends PartnerTypedRepository
        <CustomBkOptions, Long, CustomBkOptionsRepositoryContainer, CustomBkOptionsRepositoryContainer> {


    @Autowired
    public CustomBkOptionsTypedRepository(DSLContext dslContext,
                                          CustomBkOptionsRepositoryTypeSupportFacade typeSupportFacade,
                                          CustomBkOptionsModelFilterContainer metaFilterService) {
        super(dslContext, typeSupportFacade, metaFilterService);

    }

    @Override
    protected Filter getIdFilter(Collection<Long> modelIds) {
        return CustomBkOptionsFilterFactory.customBkOptionsIdsFilter(modelIds);
    }

    @Override
    protected Table<?> getBaseTable() {
        return CUSTOM_BK_OPTIONS;
    }

    public List<CustomBkOptions> getAll(
            CoreFilterNode<CustomBkOptions> coreFilterNode,
            Set<ModelProperty<? extends Model, ?>> modelProperties) {
        return getAll(QueryOpts.forClass(CustomBkOptions.class)
                .withFilter(coreFilterNode)
                .withProps(modelProperties)
        );
    }

    @Override
    protected <S extends CustomBkOptions> CoreFilterNode<S> getCoreFilterNodeById(Collection<Long> ids) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    protected ModelProperty<? extends Model, Long> getIdModelProperty() {
        return CustomBkOptions.ID;
    }
}
