package ru.yandex.partner.core.entity.custombkoptions.filter;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.multitype.repository.filter.ConditionFilter;

import static ru.yandex.direct.multitype.repository.filter.ConditionFilterFactory.whereInFilter;
import static ru.yandex.partner.dbschema.partner.Tables.CUSTOM_BK_OPTIONS;

@ParametersAreNonnullByDefault
public class CustomBkOptionsFilterFactory {
    private CustomBkOptionsFilterFactory() {
    }

    public static ConditionFilter customBkOptionsIdsFilter(Collection<Long> customBkOptionsIds) {
        return whereInFilter(CUSTOM_BK_OPTIONS.ID, customBkOptionsIds);
    }
}
