package ru.yandex.partner.core.entity.designtemplates

import org.springframework.context.annotation.Bean
import org.springframework.context.annotation.Configuration
import ru.yandex.direct.multitype.typesupport.TypeSupportAffectionHelper
import ru.yandex.partner.core.entity.common.editablefields.EditableFieldsService
import ru.yandex.partner.core.entity.designtemplates.model.BaseDesignTemplates
import ru.yandex.partner.core.entity.designtemplates.repository.DesignTemplatesRepositoryTypeSupportFacade

@Configuration
class DesignTemplatesConfiguration {

    @Bean
    fun dtTypeSupportAffectionHelper(): TypeSupportAffectionHelper<BaseDesignTemplates> {
        return TypeSupportAffectionHelper<BaseDesignTemplates>(emptySet())
    }

    @Bean
    fun dtEditableFieldsService(
        facade: DesignTemplatesRepositoryTypeSupportFacade,
        helper: TypeSupportAffectionHelper<BaseDesignTemplates>): EditableFieldsService<BaseDesignTemplates> {
        return EditableFieldsService<BaseDesignTemplates>(facade, helper)
    }

}
