package ru.yandex.partner.core.entity.designtemplates.actions;

import java.util.Collection;

import ru.yandex.partner.core.action.AbstractTransitionActionWithModelProperty;
import ru.yandex.partner.core.action.ActionConfiguration;
import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionModelContainerWithModelProperty;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.entity.designtemplates.model.DesignTemplates;
import ru.yandex.partner.core.multistate.Multistate;
import ru.yandex.partner.core.multistate.designtemplates.DesignTemplatesMultistate;
import ru.yandex.partner.core.multistate.designtemplates.DesignTemplatesStateFlag;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;


public abstract class DesignTemplatesAction
        extends AbstractTransitionActionWithModelProperty<DesignTemplates, DesignTemplatesStateFlag, Void> {

    public DesignTemplatesAction(
            ActionConfiguration<DesignTemplates, ?> parentFactory,
            String name,
            Collection<Long> containerIds,
            MultistateGraph<DesignTemplates, DesignTemplatesStateFlag> multistateGraph,
            ActionPerformer actionPerformer,
            ActionErrorHandler<DesignTemplates> actionErrorHandler
    ) {
        super(parentFactory, name, containerIds, multistateGraph, actionPerformer, actionErrorHandler);
    }

    @Override
    public Multistate<DesignTemplatesStateFlag> getMultistate(DesignTemplates model) {
        return model.getMultistate();
    }

    @Override
    public void setMultistate(ActionModelContainerWithModelProperty<DesignTemplates> container,
                              Multistate<DesignTemplatesStateFlag> multistate) {
        container.changeProperty(DesignTemplates.MULTISTATE,
                new DesignTemplatesMultistate(multistate.getEnabledFlags()));
    }


    @Override
    public Class<DesignTemplates> getEntityClass() {
        return DesignTemplates.class;
    }
}
