package ru.yandex.partner.core.entity.designtemplates.actions;

import org.jooq.DSLContext;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

import ru.yandex.direct.multitype.service.type.update.UpdateOperationTypeSupportFacade;
import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionUserIdContext;
import ru.yandex.partner.core.action.SimpleActionErrorHandler;
import ru.yandex.partner.core.action.TypeSupportActionContext;
import ru.yandex.partner.core.action.log.ActionsLogger;
import ru.yandex.partner.core.action.log.SimpleDbActionLogger;
import ru.yandex.partner.core.configuration.annotation.TransactionWithFallbackScope;
import ru.yandex.partner.core.entity.ModelQueryService;
import ru.yandex.partner.core.entity.designtemplates.DesignTemplatesCopyMapper;
import ru.yandex.partner.core.entity.designtemplates.container.DesignTemplatesOperationContainer;
import ru.yandex.partner.core.entity.designtemplates.model.BaseDesignTemplates;
import ru.yandex.partner.core.entity.designtemplates.model.CommonDesignTemplates;
import ru.yandex.partner.core.entity.designtemplates.model.DesignTemplates;
import ru.yandex.partner.core.entity.designtemplates.repository.DesignTemplatesModifyRepository;
import ru.yandex.partner.core.entity.designtemplates.service.validation.DesignTemplatesValidationTypeSupportFacade;
import ru.yandex.partner.dbschema.partner.tables.DesignTemplatesActionLog;
import ru.yandex.partner.dbschema.partner.tables.records.DesignTemplatesActionLogRecord;
import ru.yandex.partner.defaultconfiguration.PartnerLocalDateTime;

@Configuration
public class DesignTemplatesActionConfig {
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    @Bean
    TypeSupportActionContext<BaseDesignTemplates, DesignTemplates,
            DesignTemplatesOperationContainer> designTemplatesActionContext(
            DSLContext dslContext,
            ModelQueryService<CommonDesignTemplates> modelQueryService,
            DesignTemplatesCopyMapper designTemplatesCopyMapper,
            UpdateOperationTypeSupportFacade<BaseDesignTemplates,
                    DesignTemplatesOperationContainer,
                    DesignTemplatesOperationContainer,
                    DesignTemplatesOperationContainer> updateOperationTypeSupport,
            DesignTemplatesModifyRepository modifyRepository,
            DesignTemplatesValidationTypeSupportFacade validationTypeSupportFacade,
            ActionUserIdContext actionUserIdContext
    ) {
        return new DesignTemplatesActionContext(
                dslContext,
                designTemplatesActionsLogger(dslContext, actionUserIdContext),
                designTemplatesErrorHandler(),
                modelQueryService,
                designTemplatesCopyMapper::copy,
                updateOperationTypeSupport,
                modifyRepository,
                validationTypeSupportFacade
        );
    }

    @TransactionWithFallbackScope
    @Bean
    ActionErrorHandler<DesignTemplates> designTemplatesErrorHandler() {
        return new SimpleActionErrorHandler<>();
    }

    @Bean
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    ActionsLogger designTemplatesActionsLogger(DSLContext dslContext, ActionUserIdContext actionUserIdContext) {
        return new SimpleDbActionLogger<>(
                dslContext,
                DesignTemplatesActionLog.DESIGN_TEMPLATES_ACTION_LOG,
                this::buildActionLogRecord,
                actionUserIdContext
        );
    }

    public DesignTemplatesActionLogRecord buildActionLogRecord(
            Long userId, Long modelId, long oldMultistate, String actionName, long newMultistate, String opts) {
        var record = new DesignTemplatesActionLogRecord();
        record.setDt(PartnerLocalDateTime.now());
        record.setUserId(userId);
        record.setElemId(modelId);
        record.setOldMultistate(oldMultistate);
        record.setAction(actionName);
        record.setNewMultistate(newMultistate);
        record.setOpts(opts);
        return record;
    }
}
