package ru.yandex.partner.core.entity.designtemplates.actions;

import java.util.function.Function;

import org.jooq.DSLContext;

import ru.yandex.direct.multitype.repository.TypeModifyRepository;
import ru.yandex.direct.multitype.service.type.update.UpdateOperationTypeSupportFacade;
import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.TypeSupportActionContext;
import ru.yandex.partner.core.action.log.ActionsLogger;
import ru.yandex.partner.core.entity.ModelQueryService;
import ru.yandex.partner.core.entity.designtemplates.container.DesignTemplatesOperationContainer;
import ru.yandex.partner.core.entity.designtemplates.model.BaseDesignTemplates;
import ru.yandex.partner.core.entity.designtemplates.model.DesignTemplates;
import ru.yandex.partner.core.multitype.service.validation.type.ValidationTypeSupportFacade;


public class DesignTemplatesActionContext extends TypeSupportActionContext<BaseDesignTemplates, DesignTemplates,
        DesignTemplatesOperationContainer> {
    @SuppressWarnings("ParameterNumber")
    public DesignTemplatesActionContext(
            DSLContext dslContext,
            ActionsLogger actionsLogger,
            ActionErrorHandler<DesignTemplates> actionErrorHandler,
            ModelQueryService<? super DesignTemplates> queryService,
            Function<DesignTemplates, DesignTemplates> copyFunction,
            UpdateOperationTypeSupportFacade<BaseDesignTemplates,
                    DesignTemplatesOperationContainer,
                    DesignTemplatesOperationContainer,
                    DesignTemplatesOperationContainer
                    > updateOperationTypeSupport,
            TypeModifyRepository<BaseDesignTemplates, BaseDesignTemplates,
                    DesignTemplatesOperationContainer, DesignTemplatesOperationContainer> modifyRepository,
            ValidationTypeSupportFacade<BaseDesignTemplates,
                    DesignTemplatesOperationContainer, DesignTemplatesOperationContainer> validationTypeSupportFacade
    ) {
        super(
                DesignTemplates.class,
                actionsLogger,
                actionErrorHandler,
                queryService,
                copyFunction,
                dslContext,
                updateOperationTypeSupport,
                modifyRepository,
                validationTypeSupportFacade,
                DesignTemplatesOperationContainer::create
        );
    }
}
